package com.patzn.lims.sys.enums;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 系统模块枚举
 * </p>
 *
 * @author hubin
 * @since 2017-10-17
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum SysModuleTypeEnum implements IBaseEnum {
  SYS(0, "系统管理"),
  RES(1, "资源管理"),
  ENV(2, "环境检测"),
  ENV_SIMPLE(3, "简版环境检测"),
  FOOD(4, "食品检测"),
  STD(5, "标准查询"),
  METR(6, "计量检定");

  private int value;
  private String display;

  SysModuleTypeEnum(int value, String display) {
    this.value = value;
    this.display = display;
  }

  public static SysModuleTypeEnum fromName(String name) {
    if (StringUtils.isNotBlank(name)) {
      SysModuleTypeEnum[] types = SysModuleTypeEnum.values();
      for (SysModuleTypeEnum type : types) {
        if (type.getName().equalsIgnoreCase(name)) {
          return type;
        }
      }
    }
    return null;
  }

  @Override
  public Serializable getValue() {
    return value;
  }

  @Override
  public String getName() {
    return name();
  }

  @Override
  public String getDisplay() {
    return display;
  }
}
