package com.patzn.lims.sys.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 短信验证码类型枚举
 * </p>
 *
 * @author hubin
 * @since 2017-10-17
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum SysSmsCodeTypeEnum implements IBaseEnum {
  /**
   * 0、注册
   */
  REGISTER(0, "注册"),
  /**
   * 1、登录
   */
  LOGIN(1, "登录");

  private int value;
  private String display;

  SysSmsCodeTypeEnum(final int value, final String display) {
    this.value = value;
    this.display = display;
  }

  @Override
  public Serializable getValue() {
    return this.value;
  }

  @Override
  public String getName() {
    return this.name();
  }

  @Override
  public String getDisplay() {
    return this.display;
  }
}
