package com.patzn.lims.sys.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 用户授权枚举
 * </p>
 *
 * @author hubin
 * @since 2017-10-17
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum SysUserAccreditEnum implements IBaseEnum {
  /**
   * 0、普通
   */
  NORMAL(0, "普通"),
  /**
   * 1、允许进入后台
   */
  ALLOW(1, "允许进入后台");

  private int value;
  private String display;


  SysUserAccreditEnum(final int value, final String display) {
    this.value = value;
    this.display = display;
  }


  public static SysUserAccreditEnum fromName(String name) {
    for (SysUserAccreditEnum accreditEnum : SysUserAccreditEnum.values()) {
      if (accreditEnum.getName().equals(name)) {
        return accreditEnum;
      }
    }
    return null;
  }


  @Override
  public Serializable getValue() {
    return this.value;
  }

  @Override
  public String getName() {
    return this.name();
  }

  @Override
  public String getDisplay() {
    return this.display;
  }
}
