package com.patzn.lims.sys.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 用户第三方平台枚举
 * </p>
 *
 * @author hubin
 * @since 2017-11-17
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum SysUserPlatformEnum implements IBaseEnum {
  /**
   * 0、微信开发平台
   */
  WECHAT(0, "微信");

  private int value;
  private String display;

  SysUserPlatformEnum(final int value, final String display) {
    this.value = value;
    this.display = display;
  }

  @Override
  public Serializable getValue() {
    return this.value;
  }

  @Override
  public String getName() {
    return this.name();
  }

  @Override
  public String getDisplay() {
    return this.display;
  }
}
