package com.patzn.lims.sys.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 用户类型枚举
 * </p>
 *
 * @author hubin
 * @since 2017-10-17
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum SysUserTypeEnum implements IBaseEnum {
    /**
     * 0、平台用户
     */
    SYSTEM(0, "平台用户"),
    /**
     * 1、企业
     */
    COMPANY(1, "企业"),
    /**
     * 2、机构
     */
    ORG(2, "机构"),
    /**
     * 3、个人
     */
    PERSONAL(3, "个人");

    private int value;
    private String display;

    SysUserTypeEnum(final int value, final String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDisplay() {
        return this.display;
    }
}
