package com.patzn.lims.sys.enums;

/**
 * <p>
 * 验证码枚举
 * </p>
 *
 * @author hubin
 * @since 2018-04-16
 */
public enum VerificationCodeEnum {
    LOGIN("loginByMobile", "SMS_166486464"),
    EXPERIENCE("experienceByMobile", "SMS_166476496"),
    REGISTER("registerByMobile", "SMS_166476498"),
    CHANGE_PASSWORD("changePasswordByMobile", "SMS_166476503"),
    BIND_MOBILE("bindMobile", "SMS_166476505"),
    BIND_CHANGE_MOBILE("bindChangeMobile", "SMS_166476507"),
    BIND_EMAIL("bindEmail", "绑定电子邮箱");

    private String prefix;
    /**
     * 阿里云（ 账号 国海智云 j18661619072 ）
     */
    private String templateId;

    VerificationCodeEnum(String prefix, String templateId) {
        this.prefix = prefix;
        this.templateId = templateId;
    }

    public static VerificationCodeEnum fromPrefix(String prefix) {
        VerificationCodeEnum[] cke = VerificationCodeEnum.values();
        for (VerificationCodeEnum ck : cke) {
            if (ck.prefix.equals(prefix)) {
                return ck;
            }
        }
        return null;
    }

    public String getKey(String... values) {
        StringBuffer key = new StringBuffer();
        key.append(getPrefix());
        for (String value : values) {
            key.append("#").append(value);
        }
        return key.toString();
    }

    public String getPrefix() {
        return prefix;
    }

    public String getTemplateId() {
        return templateId;
    }
}
