package com.patzn.lims.sys.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 微信类型枚举
 * </p>
 *
 * @author hubin
 * @since 2018-04-27
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum WxTypeEnum implements IBaseEnum {
    MP(0, "微信公众号"),
    MA(1, "微信小程序");

    private int value;
    private String display;

    WxTypeEnum(final int value, final String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDisplay() {
        return this.display;
    }
}
