package com.patzn.lims.sys.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.patzn.lims.sys.entity.SysCompanyRelTableColumn;
import com.patzn.lims.sys.entity.SysResource;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 企业表格字段关联表 Mapper 接口
 * </p>
 *
 * @author hubin
 * @since 2018-10-31
 */
public interface SysCompanyRelTableColumnMapper extends BaseMapper<SysCompanyRelTableColumn> {


    List<Long> selectColumnIds(@Param("companyId") Long companyId);


    List<String> selectColumns(@Param("companyId") Long companyId, @Param("tableName") String tableName);


    /**
     * <p>
     * 以资源树的形式展示表格字段勾选
     * </p>
     *
     * @param companyId 企业 ID
     * @return
     */
    List<SysResource> selectTree(@Param("companyId") Long companyId);
}
