package com.patzn.lims.sys.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.sys.entity.SysModule;
import com.patzn.lims.sys.enums.SysModuleTypeEnum;
import com.patzn.lims.sys.vo.SysModuleVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 模块表 Mapper 接口
 * </p>
 *
 * @author patzn
 * @since 2017-10-25
 */
public interface SysModuleMapper extends BaseMapper<SysModule> {

    List<SysModuleVO> selectByUserId(Page page, @Param("sysModule") SysModule sysModule, @Param("userId") Long userId);


    List<SysModule> selectCompanyModule(@Param("companyId") Long companyId, @Param("systemId") Long systemId);


    List<SysModule> selectSystemModule(@Param("systemId") Long systemId, @Param("account") Account account);


    List<SysModule> selectUserModule(@Param("userId") Long userId, @Param("type") SysModuleTypeEnum type);
}
