package com.patzn.lims.sys.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.sys.entity.SysOrg;
import com.patzn.lims.sys.vo.SysOrgVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 组织表 Mapper 接口
 * </p>
 *
 * @author patzn
 * @since 2017-07-10
 */
public interface SysOrgMapper extends BaseMapper<SysOrg> {


    SysOrgVO selectVoById(@Param("companyId") Long companyId, @Param("id") Long id);


    List<SysOrgVO> selectPageVo(Page page, @Param("sysOrg") SysOrg sysOrg);


    /**
     * 递归分页
     */
    List<SysOrgVO> selectPageRecursive(Page page, @Param("sysOrg") SysOrg sysOrg);


    String selectNamesByUserId(@Param("userId") Long userId);


    /**
     * 获取一条用户所属部门信息
     */
    SysOrg selectOneByUserId(@Param("userId") Long userId);

    /**
     * 获取用户所属部门信息
     */
    List<SysOrg> selectListByUserId(@Param("userId") Long userId);
}
