package com.patzn.lims.sys.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.sys.entity.SysResource;
import com.patzn.lims.sys.vo.SysResourceVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 资源表 Mapper 接口
 * </p>
 *
 * @author patzn
 * @since 2017-07-10
 */
public interface SysResourceMapper extends BaseMapper<SysResource> {


    SysResourceVO selectVoById(@Param("id") Long id);

    /**
     * 递归分页
     */
    List<SysResourceVO> selectPageRecursive(Page page, @Param("sysResource") SysResource sysResource);


    List<String> selectListBtn(@Param("userId") Long userId);


    List<SysResourceVO> selectPageVo(Page page, @Param("sysResource") SysResource sysResource);


    List<SysResource> selectMenuTree(@Param("vo") SysResourceVO vo);


    List<SysResource> selectNavMenu(@Param("userId") Long userId, @Param("code") String code);


    List<SysResource> selectAppMenu(@Param("userId") Long userId);
}
