package com.patzn.lims.sys.mapper;

import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.sys.entity.SysRoleRelFileFolder;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 角色文件夹关联表 Mapper 接口
 * </p>
 *
 * @author patzn
 * @since 2017-11-06
 */
public interface SysRoleRelFileFolderMapper extends BaseMapper<SysRoleRelFileFolder> {

    /**
     * 查询用户文件夹权限
     */
    int selectUserAuthorize(@Param("account") Account account, @Param("folderId") Long folderId, @Param("authorize") Serializable authorize);

    @SqlParser(filter = true)
    List<Integer> selectAuthorizeByFolderId(@Param("companyId") Long companyId, @Param("userId") Long userId, @Param("folderId") Long folderId);

    @SqlParser(filter = true)
    List<Integer> selectAuthorizeRecursiveByFolderId(@Param("companyId") Long companyId, @Param("userId") Long userId, @Param("folderId") Long folderId);
}