package com.patzn.lims.sys.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.sys.entity.SysUser;
import com.patzn.lims.sys.enums.WxTypeEnum;
import com.patzn.lims.sys.vo.SysUserVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 用户表 Mapper 接口
 * </p>
 *
 * @author patzn
 * @since 2017-07-10
 */
public interface SysUserMapper extends BaseMapper<SysUser> {


    List<SysUser> selectPageByVO(Page page, @Param("vo") SysUserVO vo);


    List<SysUserVO> selectListByVO(@Param("vo") SysUserVO vo);


    List<SysUser> selectListByRoleName(@Param("companyId") Long companyId, @Param("roleName") String roleName);


    List<SysUser> selectPageFlowMemberShip(Page page, @Param("groupId") String groupId, @Param("vo") SysUserVO vo);


    List<SysUser> selectPageFlowExcludeMemberShip(Page page, @Param("groupId") String groupId, @Param("vo") SysUserVO vo);


    /**
     * <p>
     * 根据 消息 ID 查询未发送过该消息的用户
     * </p>
     *
     * @param rowBounds 分页对象
     * @param messageId 消息 ID
     * @param sysUser   用户对象
     * @return
     */
    List<SysUser> selectPageNotSendMessage(Page page, @Param("messageId") Long messageId, @Param("sysUser") SysUser sysUser);


    /**
     * <p>
     * 根据微信 开发平台 ID 查询绑定用户信息
     * </p>
     *
     * @param openid 开发平台 ID
     * @param type   类型
     * @return
     */
    SysUser selectByWxOpenid(@Param("openid") String openid, @Param("type") WxTypeEnum type);
}
