package com.patzn.lims.sys.mapper;

import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.sys.entity.SysUser;
import com.patzn.lims.sys.entity.SysUserRelOrg;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 用户组织关联表 Mapper 接口
 * </p>
 *
 * @author patzn
 * @since 2017-08-03
 */
public interface SysUserRelOrgMapper extends BaseMapper<SysUserRelOrg> {

    @SqlParser(filter = true)
    List<SysUser> selectPageByOrgId(Page page, @Param("orgId") Long orgId,
                                    @Param("companyId") Long companyId,
                                    @Param("activation") boolean activation,
                                    @Param("realname") String realname);


    @SqlParser(filter = true)
    List<SysUser> selectListByOrgId(@Param("orgId") Long orgId, @Param("companyId") Long companyId,
                                    @Param("realname") String realname);


    List<SysUser> selectListByCompanyId(@Param("companyId") Long companyId,
                                        @Param("realname") String realname);

    @SqlParser(filter = true)
    List<SysUser> selectListByOrgIdNo(@Param("orgId") Long orgId, @Param("companyId") Long companyId);
}
