package com.patzn.lims.sys.service;

import com.patzn.lims.core.web.Account;

import javax.servlet.http.HttpServletRequest;

public interface IEmailService {


    /**
     * <p>
     * 发送邮箱验证码
     * </p>
     *
     * @param request 当前请求
     * @param account 账号信息
     * @param email   电子邮箱
     * @return
     */
    boolean sendValidCode(HttpServletRequest request, Account account, String email);


    /**
     * <p>
     * 通过验证码绑定账号
     * </p>
     *
     * @param account  账号信息
     * @param vailCode 验证码
     * @return
     */
    boolean bindByCode(Account account, String vailCode);
}
