package com.patzn.lims.sys.service;

import com.patzn.lims.core.web.Account;
import com.patzn.lims.sys.enums.VerificationCodeEnum;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 短信验证码表 服务类
 * </p>
 *
 * @author patzn
 * @since 2018-03-31
 */
public interface ISmsService {


    /**
     * <p>
     * 发送短信验证码
     * </p>
     *
     * @param request 当前 HTTP 请求
     * @param account 当前账户信息
     * @param module  模块
     * @param mobile  手机号
     * @return
     */
    boolean sendValidCode(HttpServletRequest request, Account account, String module, String mobile);


    /**
     * <p>
     * 手机号码绑定
     * </p>
     *
     * @param verificationCodeEnum 验证码枚举
     * @param account              当前账户信息
     * @param vailCode             验证码
     * @return
     */
    boolean bindByCode(VerificationCodeEnum verificationCodeEnum, Account account, String vailCode);
}
