package com.patzn.lims.sys.service;

import com.patzn.lims.sys.dto.TableColumnDTO;
import com.patzn.lims.sys.entity.SysCompanyRelTableColumn;
import com.patzn.lims.sys.entity.SysResource;
import com.patzn.lims.core.web.IBaseService;

import java.util.List;

/**
 * <p>
 * 企业表格字段关联表 服务类
 * </p>
 *
 * @author hubin
 * @since 2018-10-31
 */
public interface ISysCompanyRelTableColumnService extends IBaseService<SysCompanyRelTableColumn> {


    List<Long> listIds(Long companyId);


    List<String> listCodes(Long companyId, String tableName);


    boolean save(TableColumnDTO dto);


    /**
     * <p>
     * 表格字段挂载菜单树下选择
     * </p>
     *
     * @param companyId 企业 ID
     * @return
     */
    List<SysResource> listTree(Long companyId);
}
