package com.patzn.lims.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.sys.entity.SysFile;
import com.patzn.lims.sys.entity.SysFileHis;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 文件表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-10-30
 */
public interface ISysFileService extends IBaseService<SysFile> {


    Page<SysFile> page(Page<SysFile> page, SysFile sysFile);


    List<SysFile> list(SysFile sysFile);


    List<SysFileHis> listHis(Long fileId);


    boolean save(Account account, MultipartFile file, SysFile sysFile);


    boolean removeByIds(Account account, Long[] ids);


    /**
     * <p>
     * 检测历史版本
     * </p>
     *
     * @param fileHisId
     * @return
     */
    boolean checkOutFileHis(Long fileHisId);


    /**
     * <p>
     * 文件下载
     * </p>
     *
     * @param response
     * @param fileId   文件 ID
     * @param history  是否为历史文件
     */
    void download(HttpServletResponse response, Long fileId, boolean history);


    int countByFolderId(Serializable folderId);


    /**
     * 获取 ID 文件权限
     *
     * @param account 用户信息
     * @param id      文件 ID
     * @return
     */
    List<Integer> getAuthorize(Account account, Long id);
}
