package com.patzn.lims.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.sys.entity.SysFileSignature;
import com.patzn.lims.sys.vo.SysFileSignatureVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 电子签名文件表 服务类
 * </p>
 *
 * @author patzn
 * @since 2018-04-02
 */
public interface ISysFileSignatureService extends IBaseService<SysFileSignature> {

  Page<SysFileSignatureVO> page(Page<SysFileSignatureVO> page, SysFileSignatureVO vo);

  boolean save(MultipartFile file, Long userId);

  void download(Long userId, HttpServletResponse response);

  String downloadBase64(Long userId);

  SysFileSignature getByUserId(Long userId);

  List<SysFileSignature> getByUserIds(List<Long> userIds);
}
