package com.patzn.lims.sys.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.sys.entity.SysFolder;

import java.util.List;

/**
 * <p>
 * 文件夹表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-10-30
 */
public interface ISysFolderService extends IBaseService<SysFolder> {


    Page<SysFolder> page(Page<SysFolder> page, SysFolder sysFolder);


    List<SysFolder> list(SysFolder sysFolder);


    /**
     * <p>
     * 查询用户授权文件夹列表
     * </p>
     *
     * @param account   账户对象
     * @param sysFolder 文件夹管理对象
     * @return
     */
    List<SysFolder> listUserAuthorize(Account account, SysFolder sysFolder);


    boolean removeById(Account account, Long id);


    /**
     * <p>
     * 初始化文件夹根
     * </p>
     *
     * @param companyId   企业 ID
     * @param companyName 企业名称
     * @return
     */
    boolean initRoot(Long companyId, String companyName);

    /**
     * 获取 ID 文件夹权限
     *
     * @param account 用户信息
     * @param id      文件夹 ID
     * @return
     */
    List<Integer> getAuthorize(Account account, Long id);
}
