package com.patzn.lims.sys.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.sys.entity.SysModule;
import com.patzn.lims.sys.vo.SysModuleVO;

import java.util.List;

/**
 * <p>
 * 模块表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-10-25
 */
public interface ISysModuleService extends IBaseService<SysModule> {


    IPage<SysModule> page(Page<SysModule> page, SysModule sysModule);


    List<SysModule> list(SysModule sysModule);


    /**
     * <p>
     * 企业关联模块列表
     * </p>
     *
     * @param companyId 企业 ID
     * @param systemId  系统 ID
     * @return
     */
    List<SysModule> listCompanyModule(Long companyId, Long systemId);


    /**
     * <p>
     * 用户关联模块列表
     * </p>
     *
     * @param systemId 系统 ID
     * @param account  登录账户信息
     * @return
     */
    List<SysModule> listSystemModule(Long systemId, Account account);


    /**
     * <p>
     * 用户关联模块列表
     * </p>
     *
     * @param userId 用户 ID
     * @param type   模块系统类型
     * @return
     */
    List<SysModule> listUserModule(Long userId, String type);


    IPage<SysModuleVO> pageByUserId(Page<SysModuleVO> page, SysModule sysModule, Account account);


    /**
     * <p>
     * 添加用户关联模块
     * </p>
     *
     * @param userId   用户 ID
     * @param moduleId 模块 Id
     * @return
     */
    boolean saveRelUser(Long userId, Long moduleId);


    /**
     * <p>
     * 根据关联 ID 删除用户模块关系
     * </p>
     *
     * @param relId 关联 ID
     * @return
     */
    boolean deleteRelUser(Long relId);
}
