package com.patzn.lims.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.sys.entity.SysOrg;
import com.patzn.lims.sys.vo.SysOrgVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.Collection;
import java.util.List;

/**
 * <p>
 * 组织表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-08-02
 */
public interface ISysOrgService extends IBaseService<SysOrg> {


    Page<SysOrgVO> page(Page<SysOrgVO> page, SysOrg sysOrg);


    /**
     * <p>
     * 递归分页
     * </p>
     *
     * @param page   分页对象
     * @param sysOrg 查询参数
     * @return
     */
    Page<SysOrgVO> pageRecursive(Page<SysOrgVO> page, SysOrg sysOrg);


    List<SysOrg> list(SysOrg sysOrg);


    List<SysOrg> lisByOrgNames(Collection<String> orgNames, Long companyId);


    /**
     * <p>
     * 查询组织机构 VO 信息
     * </p>
     *
     * @param companyId 企业ID
     * @param id        组织机构 ID
     * @return
     */
    SysOrgVO getVoById(Long companyId, Long id);


    /**
     * <p>
     * 机构部门组树查询
     * </p>
     *
     * @param name 机构名称
     * @return
     */
    List<SysOrg> getOrgTree(String name);


    /**
     * <p>
     * 获取一条用户所属部门信息
     * </p>
     *
     * @param userId 用户 ID
     * @return
     */
    SysOrg getByUserId(Long userId);


    /**
     * <p>
     * 获取用户所属部门信息
     * </p>
     *
     * @param realName 用户真实名称
     * @return
     */
    List<SysOrg> listByUserRealName(String realName);


    /**
     * <p>
     * 初始化组织根
     * </p>
     *
     * @param companyId   企业 ID
     * @param companyName 企业名称
     * @return
     */
    boolean initRoot(Long companyId, String companyName);


    /**
     * <p>
     * 查询机构名称逗号分割
     * </p>
     *
     * @param userId 用户 ID
     * @return
     */
    String getNamesByUserId(Long userId);


    /**
     * <p>
     * 导入组织
     * </p>
     *
     * @param file    导入 XLSX
     * @param account 账户信息
     * @return
     */
    boolean importOrg(MultipartFile file, Account account);


    /**
     * <p>
     * 更新组织根名称
     * </p>
     *
     * @param name      名称
     * @param companyId 企业 ID
     * @return
     */
    boolean updateRootName(String name, Long companyId);


    List<SysOrg> getListByUserId(Long e);
}
