package com.patzn.lims.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.sys.entity.SysResource;
import com.patzn.lims.sys.vo.SysResourceVO;

import java.util.List;

/**
 * <p>
 * 资源表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-07-10
 */
public interface ISysResourceService extends IBaseService<SysResource> {


    Page<SysResourceVO> page(Page<SysResourceVO> page, SysResource sysResource);


    Page<SysResourceVO> pageBtn(Page<SysResourceVO> page, SysResource sysResource);


    Page<SysResourceVO> pageRecursive(Page<SysResourceVO> page, SysResource sysResource);


    List<String> listBtn(Account account);


    /**
     * <p>
     * 查询资源 VO 信息
     * </p>
     *
     * @param id 资源 ID
     * @return
     */
    SysResourceVO getVoById(Long id);


    /**
     * <p>
     * 查询全部菜单数据
     * </p>
     */
    List<SysResource> getMenuTree(SysResourceVO vo);


    /**
     * <p>
     * 查询菜单导航
     * </p>
     *
     * @param userId 用户ID
     * @param code   系统编码
     * @return
     */
    List<Object> getNavMenu(Long userId, String code);


    /**
     * <p>
     * 查询 APP 菜单导航
     * </p>
     *
     * @param userId 用户ID
     * @return
     */
    List<SysResource> getAppMenu(Long userId);


    boolean saveBtn(Long menuId, SysResource sysResource);
}
