package com.patzn.lims.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.sys.entity.SysRoleRelFileFolder;
import com.patzn.lims.sys.enums.FolderAuthorizeEnum;

import java.util.List;

/**
 * <p>
 * 角色文件夹关联表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-11-06
 */
public interface ISysRoleRelFileFolderService extends IBaseService<SysRoleRelFileFolder> {

  Page<SysRoleRelFileFolder> page(Page<SysRoleRelFileFolder> page, SysRoleRelFileFolder sysRoleRelFileFolder);

  List<SysRoleRelFileFolder> list(SysRoleRelFileFolder sysRoleRelFileFolder);

  List<SysRoleRelFileFolder> getRelFileFolder(Long roleId, String authorize);

  boolean saveRoleAuthorize(Long companyId, Long roleId, Long[] folderIds, FolderAuthorizeEnum folderAuthorizeEnum);

  /**
   * <p>
   * 授予角色查看上传删除权限
   * </p>
   *
   * @param companyId 企业 ID
   * @param roleId    角色 ID
   * @param folderId  文件夹 ID
   * @return
   */
  boolean saveLookUploadRemoveAuthorize(Long companyId, Long roleId, Long folderId);

  /**
   * <p>
   * 查询用户文件夹权限
   * </p>
   *
   * @param account   账号信息
   * @param folderId  文件夹ID
   * @param authorize 文件权限
   * @return
   */
  boolean getUserAuthorize(Account account, Long folderId, FolderAuthorizeEnum authorize);

  boolean removeByFolderId(Long folderId);

  List<Integer> getAuthorizeByFolderId(Account account, Long folderId);
}
