package com.patzn.lims.sys.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.sys.entity.SysRoleRelResource;
import com.patzn.lims.core.web.IBaseService;

import java.util.List;

/**
 * <p>
 * 角色资源关联表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-08-03
 */
public interface ISysRoleRelResourceService extends IBaseService<SysRoleRelResource> {

    IPage<SysRoleRelResource> page(Page<SysRoleRelResource> page, SysRoleRelResource sysRoleRelResource);

    List<SysRoleRelResource> list(SysRoleRelResource sysRoleRelResource);

    List<SysRoleRelResource> getRelResource(Long roleId);

    /**
     * <p>
     * 添加角色资源
     * </p>
     *
     * @param roleId      角色 ID
     * @param resourceIds 资源 ID 集合
     * @return
     */
    boolean addRelResource(Long roleId, List<Long> resourceIds);
}
