package com.patzn.lims.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.sys.entity.SysRole;
import com.patzn.lims.sys.vo.SysRoleVO;
import com.patzn.lims.core.web.IBaseService;

import java.util.Collection;
import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-08-02
 */
public interface ISysRoleService extends IBaseService<SysRole> {


    Page<SysRoleVO> page(Page<SysRoleVO> page, SysRole sysRole);


    /**
     * <p>
     * 递归分页
     * </p>
     *
     * @param page    分页对象
     * @param sysRole 查询参数
     * @return
     */
    Page<SysRoleVO> pageRecursive(Page<SysRoleVO> page, SysRole sysRole);


    List<SysRole> list(SysRole sysRole);


    List<SysRole> listByRoleNames(Collection<String> roleNames, Long companyId);


    /**
     * <p>
     * 查询角色 DTO 信息
     * </p>
     *
     * @param companyId 企业ID
     * @param id        组织机构 ID
     * @return
     */
    SysRoleVO getVoById(Long companyId, Long id);


    List<SysRole> getRoleTree(String name);


    List<SysRole> listByUserId(Long userId);


    /**
     * <p>
     * 随机获取一个用户角色 ID
     * </p>
     */
    Long getFirstRelRole(Long companyId);


    /**
     * <p>
     * 查询角色名称逗号分割
     * </p>
     *
     * @param userId 用户 ID
     * @return
     */
    String getNamesByUserId(Long userId);
}
