package com.patzn.lims.sys.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.sys.entity.SysUser;
import com.patzn.lims.sys.entity.SysUserPlatform;
import com.patzn.lims.core.web.IBaseService;

import java.util.List;

/**
 * <p>
 * 第三方平台用户表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-11-17
 */
public interface ISysUserPlatformService extends IBaseService<SysUserPlatform> {


    IPage<SysUserPlatform> page(Page<SysUserPlatform> page, SysUserPlatform sysUserPlatform);


    List<SysUserPlatform> list(SysUserPlatform sysUserPlatform);


    boolean bindUser(SysUserPlatform sysUserPlatform);


    boolean bindWechat(Long userId, String code);


    /**
     * <p>
     * 获取第三方平台绑定用户
     * </p>
     *
     * @param openid   开放平台 ID
     * @param platform 平台
     * @return
     */
    SysUser getBindUser(String openid, int platform);


    /**
     * <p>
     * 获取微信平台绑定信息
     * </p>
     *
     * @param userId 用户 ID
     * @return
     */
    SysUserPlatform getWechatInfo(Long userId);
}
