package com.patzn.lims.sys.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.sys.entity.SysUserRelModule;
import com.patzn.lims.core.web.IBaseService;

import java.util.List;

/**
 * <p>
 * 用户模块关联表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-10-25
 */
public interface ISysUserRelModuleService extends IBaseService<SysUserRelModule> {


    IPage<SysUserRelModule> page(Page<SysUserRelModule> page, SysUserRelModule sysUserRelModule);


    List<SysUserRelModule> list(SysUserRelModule sysUserRelModule);


    /**
     * <p>
     * 根据关联 ID 删除用户模块关系
     * </p>
     *
     * @param userId   用户 ID
     * @param moduleId 模块 ID
     * @return
     */
    boolean remove(Long userId, Long moduleId);
}
