package com.patzn.lims.sys.service;

import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.sys.dto.UserTableColumnDTO;
import com.patzn.lims.sys.entity.SysUserRelTableColumn;

import java.util.List;

/**
 * <p>
 * 用户表格字段关联表 服务类
 * </p>
 *
 * @author hubin
 * @since 2018-10-31
 */
public interface ISysUserRelTableColumnService extends IBaseService<SysUserRelTableColumn> {


    List<SysUserRelTableColumn> list(SysUserRelTableColumn sysUserRelTableColumn);


    boolean save(Long userId, UserTableColumnDTO dto);


    boolean removeByCompanyId(Long companyId);


    /**
     * <p>
     * 查询指定用户表名自定义查看字段列
     * </p>
     *
     * @param account   登录用户信息
     * @param tableName 表名
     * @return
     */
    List<String> listCodes(Account account, String tableName);
}
