package com.patzn.lims.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.sys.dto.SysUserDTO;
import com.patzn.lims.sys.dto.UserRegDTO;
import com.patzn.lims.sys.entity.SysUser;
import com.patzn.lims.sys.enums.WxTypeEnum;
import com.patzn.lims.sys.vo.SysUserVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 用户表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-07-10
 */
public interface ISysUserService extends IBaseService<SysUser> {


    /**
     * <p>
     * 用户激活
     * </p>
     *
     * @param user   用户
     * @param newPwd 新密码
     * @return
     */
    boolean activation(SysUser user, String newPwd);


    /**
     * <p>
     * 普通用户注册
     * </p>
     *
     * @param dto 注册信息
     * @param ip  注册 IP
     * @return
     */
    boolean register(UserRegDTO dto, String ip);


    boolean saveManager(SysUserDTO dto);


    void otpQrCode(HttpServletResponse response, int width, int height, Long userId);


    boolean otpOnOff(Long userId, Integer code);

    void qrCode(String contents, Integer width, Integer height, HttpServletResponse response);

    /**
     * <p>
     * 导出用户信息
     * </p>
     *
     * @param response  响应请求
     * @param companyId 企业 ID
     * @param vo        用户对象查询条件
     */
    void exportUser(HttpServletResponse response, Long companyId, SysUserVO vo);


    /**
     * <p>
     * 查询管理员信息
     * </p>
     *
     * @param companyId 企业 ID
     * @return
     */
    Map<String, Object> managerInfo(Long companyId);


    Page<SysUser> page(Page<SysUser> page, SysUserVO vo);


    Page<SysUser> pageFlowMemberShip(Page<SysUser> page, String groupId, SysUserVO vo);


    Page<SysUser> pageNotSendMessage(Page<SysUser> page, Long messageId, SysUser sysUser);


    Page<SysUser> pageFlowExcludeMemberShip(Page<SysUser> page, String groupId, SysUserVO vo);


    List<SysUser> list(SysUser sysUser);


    List<SysUser> listByRoleName(Long companyId, String roleName);


    List<SysUserVO> listVO(SysUserVO vo);


    /**
     * <p>
     * 用户登录
     * </p>
     *
     * @param username  用户名
     * @param password  密码
     * @param loginBack 是否登录后台
     * @return
     */
    SysUser login(String username, String password, boolean loginBack);


    SysUser login(String username, String password);


    /**
     * <p>
     * 通过 HTML5 端登录返回 Token
     * </p>
     *
     * @param request  当前请求
     * @param username 用户名称
     * @param password 用户密码
     * @param newPwd   新密码
     * @param code     手机验证码
     * @return
     */
    String loginToken(HttpServletRequest request, String username, String password, String newPwd, String code);

    /**
     * <p>
     * 通过 HTML5 端登录返回 Token
     * </p>
     *
     * @param request  当前请求
     * @param type     微信类型
     * @param openid   微信开放平台 ID
     * @param username 用户名称
     * @param password 用户密码
     * @return
     */
    String loginToken(HttpServletRequest request, WxTypeEnum type, String openid, String username, String password);


    /**
     * <p>
     * 根据手机号码查询用户信息
     * </p>
     *
     * @param mobile 手机号码
     * @return
     */
    SysUser getByMobile(String mobile);

    /**
     * <p>
     * 根据登录账号查询用户信息
     * </p>
     *
     * @param username 用户名
     * @return
     */
    SysUser getByUserName(String username);


    SysUser getByRealName(String realname);


    boolean updateDtoById(SysUserDTO dto);


    boolean saveDto(SysUserDTO dto);


    /**
     * <p>
     * 判断手机号码是否激活
     * </p>
     *
     * @param mobile 手机号码
     * @return
     */
    boolean isVerify(String mobile);


    /**
     * <p>
     * 修改登录密码
     * </p>
     *
     * @param mobile   手机号码
     * @param code     短信验证码
     * @param password 登录密码
     * @return
     */
    boolean changePassword(String mobile, String code, String password);


    /**
     * <p>
     * 修改指定用户密码
     * </p>
     *
     * @param userId 用户 ID
     * @param oldPwd 旧密码
     * @param newPwd 新密码
     * @return
     */
    boolean changePassword(Long userId, String oldPwd, String newPwd);


    /**
     * <p>
     * 验证登录密码是否正确
     * </p>
     *
     * @param password 登录密码
     * @return
     */
    boolean validPassword(Long userId, String password);


    /**
     * <p>
     * 通过短信验证码登录
     * </p>
     *
     * @param mobile 手机号码
     * @param code   短信验证码
     * @return
     */
    SysUser loginByCode(String mobile, String code);


    /**
     * <p>
     * 微信小程序登录
     * </p>
     *
     * @param request 当前请求
     * @param openid  开发平台 ID
     * @return
     */
    String loginWxMa(HttpServletRequest request, String openid);


    /**
     * <p>
     * 根据 ID 绑定邮箱
     * </p>
     *
     * @param id    用户 ID
     * @param email 电子邮箱
     * @return
     */
    boolean bindEmailById(Long id, String email);

    /**
     * <p>
     * 根据 ID 绑定手机号
     * </p>
     *
     * @param id     用户 ID
     * @param mobile 手机号
     * @return
     */
    boolean bindMobileById(Long id, String mobile);


    /**
     * <p>
     * 获取允许展示的用户信息
     * </p>
     *
     * @param id 用户 ID
     * @return
     */
    SysUserVO getAllowInfoById(Long id);

    /**
     * <p>
     * 设置用户头像
     * </p>
     *
     * @param id   用户 ID
     * @param file 头像
     * @return
     */
    String saveAvatar(Long id, MultipartFile file);


    /**
     * <p>
     * 登录合法性验证
     * </p>
     *
     * @param sysUser 用户信息
     */
    SysUser validLogin(SysUser sysUser);


    /**
     * <p>
     * 导入用户
     * </p>
     *
     * @param file    导入 XLSX
     * @param account 账户信息
     * @return
     */
    boolean importUser(MultipartFile file, Account account);
}
