package com.patzn.lims.sys.service;

import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * <p>
 * Redis 统计次数服务
 * </p>
 *
 * @author hubin
 * @since 2018-04-16
 */
@Component
public class RedisCountService {

    @Resource
    private RedisTemplate<String, Integer> redisTemplate;

    /**
     * <p>
     * 总数值
     * </p>
     *
     * @param key 缓存 KEY
     * @return
     */
    public int get(String key) {
        Integer result = redisTemplate.opsForValue().get(key);
        return null == result ? 0 : result;
    }

    /**
     * <p>
     * 统计次数 +1
     * </p>
     *
     * @param key   缓存 KEY
     * @param count 上次数
     * @param hours 小时
     */
    public void set(String key, int count, long hours) {
        redisTemplate.opsForValue().set(key, ++count, hours, TimeUnit.HOURS);
    }

}
