package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysArea;
import com.patzn.lims.sys.entity.SysCity;
import com.patzn.lims.sys.mapper.SysAreaMapper;
import com.patzn.lims.sys.service.ISysAreaService;
import com.patzn.lims.sys.service.ISysCityService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 地区表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-07-10
 */
@Service
public class SysAreaServiceImpl extends BaseServiceImpl<SysAreaMapper, SysArea> implements ISysAreaService {
  @Autowired
  private ISysCityService cityService;

  @Override
  public Page<SysArea> page(Page<SysArea> page, SysArea sysArea) {
    QueryWrapper<SysArea> wrapper = Wrappers.<SysArea>query(sysArea);
    if (StringUtils.isNotEmpty(sysArea.getCode())) {
      wrapper.like("code", sysArea.getCode());
      sysArea.setCode(null);
    }
    if (StringUtils.isNotEmpty(sysArea.getCn())) {
      wrapper.like("cn", sysArea.getCn());
      sysArea.setCn(null);
    }
    if (StringUtils.isNotEmpty(sysArea.getCityCode())) {
      wrapper.like("city_code", sysArea.getCityCode());
      sysArea.setCityCode(null);
    }
    wrapper.orderBy(true, false, "id");
    return page(page, wrapper);
  }


  @Override
  public List<SysArea> listByCityCode(String cityCode) {
    return super.list(Wrappers.<SysArea>query().eq("city_code",
            cityCode).orderBy(true, false, "code"));
  }


  @Override
  public List<Map<String, Object>> listByCityId(Long cityId) {
    SysCity sysCity = cityService.getById(cityId);
    List<SysArea> sysAreaList = list(Wrappers.<SysArea>query().eq("city_code",
            sysCity.getCode()).orderBy(true, false, "code"));
    if (CollectionUtils.isEmpty(sysAreaList)) {
      return null;
    }
    List<Map<String, Object>> listMap = sysAreaList.stream().map(sysArea -> {
      Map<String, Object> map = new HashMap<>(2);
      map.put("value", sysArea.getId());
      map.put("code", sysArea.getCode());
      map.put("label", sysArea.getCn());
      return map;
    }).collect(Collectors.toList());
    return listMap;
  }


  @Override
  public boolean save(SysArea sysArea) {
    verifyNameCode(sysArea);
    return super.save(sysArea);
  }

  @Override
  public boolean updateById(SysArea sysArea) {
    verifyNameCode(sysArea);
    return super.updateById(sysArea);
  }

  /**
   * 校验名称编号
   */
  private void verifyNameCode(SysArea sysArea) {
    if (baseMapper.selectCountByCode(sysArea) > 0) {
      PtAssert.fail("抱歉!地区编号已存在，请重新输入。");
    }
  }

  @Override
  public boolean existByCityCode(String cityCode) {
    return super.count(Wrappers.<SysArea>query().eq("city_code",
      cityCode)) > 0;
  }
}
