package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysCity;
import com.patzn.lims.sys.entity.SysProvince;
import com.patzn.lims.sys.mapper.SysCityMapper;
import com.patzn.lims.sys.service.ISysAreaService;
import com.patzn.lims.sys.service.ISysCityService;
import com.patzn.lims.sys.service.ISysProvinceService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 城市表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-07-10
 */
@Service
public class SysCityServiceImpl extends BaseServiceImpl<SysCityMapper, SysCity> implements ISysCityService {
  @Autowired
  private ISysProvinceService provinceService;
  @Autowired
  private ISysAreaService areaService;

  @Override
  public Page<SysCity> page(Page<SysCity> page, SysCity sysCity) {
    QueryWrapper<SysCity> wrapper = Wrappers.<SysCity>query(sysCity);
    if (StringUtils.isNotEmpty(sysCity.getCode())) {
      wrapper.like("code", sysCity.getCode());
      sysCity.setCode(null);
    }
    if (StringUtils.isNotEmpty(sysCity.getCn())) {
      wrapper.like("cn", sysCity.getCn());
      sysCity.setCn(null);
    }
    if (StringUtils.isNotEmpty(sysCity.getProvinceCode())) {
      wrapper.like("province_code", sysCity.getProvinceCode());
      sysCity.setProvinceCode(null);
    }
    wrapper.orderBy(true, false, "id");
    return super.page(page, wrapper);
  }


  @Override
  public List<SysCity> list(SysCity sysCity) {
    QueryWrapper<SysCity> wrapper = Wrappers.<SysCity>query();
    if (StringUtils.isNotEmpty(sysCity.getCn())) {
      wrapper.like("cn", sysCity.getCn());
      sysCity.setCn(null);
    }
    wrapper.setEntity(sysCity);
    return super.list(wrapper);
  }

  @Override
  public List<SysCity> listByProvinceCode(String provinceCode) {
    return super.list(Wrappers.<SysCity>query().eq("province_code",
            provinceCode).orderBy(true, false, "code"));
  }

  @Override
  public List<Map<String, Object>> listByProvinceId(Long provinceId) {
    SysProvince sysProvince = provinceService.getById(provinceId);
    List<SysCity> sysCityList = list(Wrappers.<SysCity>query().eq("province_code", sysProvince.getCode()));
    List<Map<String, Object>> listMap = new ArrayList<>();
    for (SysCity sysCity : sysCityList) {
      Map<String, Object> map = new HashMap<>(4);
      map.put("value", sysCity.getId());
      map.put("code", sysCity.getCode());
      map.put("label", sysCity.getCn());
      map.put("children", new ArrayList<>());
      map.put("loading", false);
      listMap.add(map);
    }
    return listMap;
  }

  @Override
  public boolean save(SysCity sysCity) {
    verifyNameCode(sysCity);
    return super.save(sysCity);
  }

  @Override
  public boolean updateById(SysCity sysCity) {
    verifyNameCode(sysCity);
    return super.updateById(sysCity);
  }

  @Override
  public boolean removeById(Serializable id) {
    SysCity sysCity = getById(id);
    PtAssert.fail(areaService.existByCityCode(sysCity.getCode()),
      "该城市存在下级区域信息，必须先删除区域信息");
    return super.removeById(id);
  }

  @Override
  public SysCity getById(Serializable id) {
    SysCity sysCity = super.getById(id);
    PtAssert.fail(null == sysCity, "抱歉选择城市不存在，请刷新后重试。");
    return sysCity;
  }

  /**
   * 校验名称编号
   */
  private void verifyNameCode(SysCity sysCity) {
    if (baseMapper.selectCountOrNameCode(sysCity) > 0) {
      PtAssert.fail("抱歉!城市名称或编号已存在，请重新输入。");
    }
  }

  @Override
  public boolean existByProvinceCode(String provinceCode) {
    return super.count(Wrappers.<SysCity>query().eq("province_code",
      provinceCode)) > 0;
  }
}
