package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysCompanyRelModule;
import com.patzn.lims.sys.mapper.SysCompanyRelModuleMapper;
import com.patzn.lims.sys.service.ISysCompanyRelModuleService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * <p>
 * 公司模块关联表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-03-07
 */
@Service
public class SysCompanyRelModuleServiceImpl extends BaseServiceImpl<SysCompanyRelModuleMapper, SysCompanyRelModule> implements ISysCompanyRelModuleService {

    @Override
    public IPage<SysCompanyRelModule> page(Page<SysCompanyRelModule> page, SysCompanyRelModule sysCompanyRelModule) {
        return this.page(page, Wrappers.query(sysCompanyRelModule));
    }

    @Override
    public boolean save(Long companyId, Long[] moduleIds) {
        if (null == companyId || null == moduleIds) {
            return false;
        }
        return super.saveBatch(Arrays.stream(moduleIds).map(moduleId -> {
            SysCompanyRelModule rel = new SysCompanyRelModule();
            rel.setCompanyId(companyId);
            rel.setModuleId(moduleId);
            return rel;
        }).collect(Collectors.toList()));
    }

    @Override
    public boolean remove(Long companyId, Long[] moduleIds) {
        return super.remove(Wrappers.<SysCompanyRelModule>query()
                .eq("company_id",  companyId)
                .in("module_id", moduleIds));
    }
}
