package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.dto.TableColumnDTO;
import com.patzn.lims.sys.entity.SysCompanyRelTableColumn;
import com.patzn.lims.sys.entity.SysResource;
import com.patzn.lims.sys.mapper.SysCompanyRelTableColumnMapper;
import com.patzn.lims.sys.service.ISysCompanyRelTableColumnService;
import com.patzn.lims.sys.service.ISysResourceService;
import com.patzn.lims.sys.service.ISysUserRelTableColumnService;
import com.patzn.lims.sys.vo.SysResourceVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 企业表格字段关联表 服务实现类
 * </p>
 *
 * @author hubin
 * @since 2018-10-31
 */
@Service
public class SysCompanyRelTableColumnServiceImpl extends BaseServiceImpl<SysCompanyRelTableColumnMapper, SysCompanyRelTableColumn> implements ISysCompanyRelTableColumnService {

    @Autowired
    private ISysResourceService sysResourceService;
    @Autowired
    private ISysUserRelTableColumnService sysUserRelTableColumnService;


    @Override
    public List<Long> listIds(Long companyId) {
        return baseMapper.selectColumnIds(companyId);
    }


    @Override
    public List<String> listCodes(Long companyId, String tableName) {
        return baseMapper.selectColumns(companyId, tableName);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean save(TableColumnDTO dto) {
        if (null != dto && null != dto.getId()
                && CollectionUtils.isNotEmpty(dto.getTableColumnIds())) {
            // 删除所属企业用户的自定义设置
            sysUserRelTableColumnService.removeByCompanyId(dto.getId());
            super.remove(Wrappers.<SysCompanyRelTableColumn>query().eq("company_id", dto.getId()));
            return super.saveBatch(dto.getTableColumnIds().stream().map(t -> {
                SysCompanyRelTableColumn rel = new SysCompanyRelTableColumn();
                rel.setCompanyId(dto.getId());
                rel.setTableColumnId(t);
                return rel;
            }).collect(Collectors.toList()));
        }
        return false;
    }


    @Override
    public List<SysResource> listTree(Long companyId) {
        SysResourceVO vo = new SysResourceVO();
        vo.setCompanyId(companyId);
        vo.setType(0);
        List<SysResource> resourceList = sysResourceService.getMenuTree(vo);
        /**
         * 添加表格字段权限至列表
         * 如果企业未曾分配过表格权限查询所有结果
         */
        if (CollectionUtils.isNotEmpty(resourceList)) {
            Integer count = baseMapper.selectCount(Wrappers.<SysCompanyRelTableColumn>query()
                    .eq("company_id", companyId));
            if (null == count || 0 == count) {
                companyId = null;
            }
            resourceList.addAll(baseMapper.selectTree(companyId));
        }
        return resourceList;
    }
}
