package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysCompany;
import com.patzn.lims.sys.mapper.SysCompanyMapper;
import com.patzn.lims.sys.service.ISysCompanyService;
import com.patzn.lims.sys.service.ISysOrgService;
import com.patzn.lims.sys.service.ISysUserPlatformService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 公司表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-07-10
 */
@Service
public class SysCompanyServiceImpl extends BaseServiceImpl<SysCompanyMapper, SysCompany> implements ISysCompanyService {
    @Autowired
    private ISysOrgService sysOrgService;
    @Autowired
    private ISysUserPlatformService sysUserPlatformService;

    @Override
    public IPage<SysCompany> page(Page<SysCompany> page, SysCompany sysCompany) {
        return page(page, Wrappers.query(sysCompany).orderByDesc("sort", "ctime"));
    }

    @Override
    public List<SysCompany> list(SysCompany sysCompany) {
        return list(Wrappers.query(sysCompany));
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean save(SysCompany sysCompany) {
        if (StringUtils.isNotEmpty(sysCompany.getName())) {
            verifyCompanyName(sysCompany);
        }
        return super.save(sysCompany);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateById(SysCompany sysCompany) {
        if (StringUtils.isNotEmpty(sysCompany.getName())) {
            verifyCompanyName(sysCompany);
            sysOrgService.updateRootName(sysCompany.getName(), sysCompany.getId());
        }
        return super.updateById(sysCompany);
    }

    /**
     * 企业名称校验
     */
    private void verifyCompanyName(SysCompany sysCompany) {
        PtAssert.fail((super.count(Wrappers.<SysCompany>query().eq("name", sysCompany.getName())
                        .ne(null != sysCompany.getId(), "id", sysCompany.getId())) > 0),
                "抱歉!该企业名称已存在，请改换名称。");
    }

    @Override
    public Map<String, Object> getMyCompanyInfo(Account account) {
        Map<String, Object> map = new HashMap<>(2);
        // 开启微信通知
        boolean notifyWechat = true;
        // 查询非帕特用户企业开启情况
        SysCompany sysCompany = getById(account.getCompanyId());
        if (null != sysCompany) {
            if (0 == sysCompany.getNotifyWechat()) {
                notifyWechat = false;
            }
        }
        map.put("notifyWechat", notifyWechat);
        map.put("countryCode2", sysCompany.getCountryCode2());
        map.put("provinceCode", sysCompany.getProvinceCode());
        map.put("cityCode", sysCompany.getCityCode());
        map.put("areaCode", sysCompany.getAreaCode());
        // 绑定微信信息
        map.put("userPlatform", sysUserPlatformService.getWechatInfo(account.getUserId()));
        return map;
    }


    @Override
    public SysCompany getById(Serializable id) {
        if (null == id) {
            return null;
        }
        SysCompany sysCompany = super.getById(id);
        PtAssert.fail(null == sysCompany, "抱歉！该企业不存在请刷新后重试，或者联系管理员。");
        return sysCompany;
    }

    @Override
    public String saveLogo(Long companyId, MultipartFile file) {
        PtAssert.fail(null == companyId || null == file, "企业 ID 或上传文件不存在");
//        OssFileResult result = ossClient.upload(file);
//        if (null != result) {
//            SysCompany sysCompany = new SysCompany();
//            sysCompany.setId(companyId);
//            sysCompany.setLogo(result.getObjectKey());
//            if (super.updateById(sysCompany)) {
//                return sysCompany.getLogo();
//            }
//        }
        return null;
    }

    @Override
    public boolean updateManager(Long id, String manager) {
        SysCompany sysCompany = new SysCompany();
        sysCompany.setId(id);
        sysCompany.setManager(manager);
        return super.updateById(sysCompany);
    }
}
