package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysFile;
import com.patzn.lims.sys.entity.SysFileHis;
import com.patzn.lims.sys.mapper.SysFileHisMapper;
import com.patzn.lims.sys.service.ISysFileHisService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 文件表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-10-30
 */
@Service
public class SysFileHisServiceImpl extends BaseServiceImpl<SysFileHisMapper, SysFileHis> implements ISysFileHisService {

    @Override
    public Page<SysFileHis> page(Page<SysFileHis> page, SysFileHis sysFileHis) {
        Wrapper wrapper = new QueryWrapper<SysFileHis>(sysFileHis);

        return this.page(page, wrapper);
    }

    @Override
    public List<SysFileHis> list(SysFileHis sysFileHis) {
        return this.list(new QueryWrapper<>(sysFileHis));
    }

    @Override
    public boolean save(SysFile sysFile) {
        if (null == sysFile) {
            return false;
        }
        SysFileHis sysFileHis = sysFile.convert(SysFileHis.class);
        // 不需要赋值主键
        sysFileHis.setId(null);
        sysFileHis.setFileId(sysFile.getId());
        return super.save(sysFileHis);
    }

    @Override
    public boolean removeByFileIds(Long[] fileIds) {
        return super.remove(Wrappers.<SysFileHis>query().in("file_id", fileIds));
    }
}
