package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.core.oss.OssFileResult;
import com.patzn.lims.core.toolkit.ImageUtils;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysFileSignature;
import com.patzn.lims.sys.entity.SysUser;
import com.patzn.lims.sys.mapper.SysFileSignatureMapper;
import com.patzn.lims.sys.service.ISysFileSignatureService;
import com.patzn.lims.sys.service.ISysUserService;
import com.patzn.lims.sys.vo.SysFileSignatureVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 电子签名文件表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-04-02
 */
@Service
public class SysFileSignatureServiceImpl extends BaseServiceImpl<SysFileSignatureMapper, SysFileSignature> implements ISysFileSignatureService {
  @Autowired
  private ISysUserService sysUserService;
  @Autowired
  private OssClient ossClient;

  @Override
  public Page<SysFileSignatureVO> page(Page<SysFileSignatureVO> page, SysFileSignatureVO vo) {
    return page.setRecords(baseMapper.selectPageVo(page, vo));
  }

  @Transactional(rollbackFor = Exception.class)
  @Override
  public boolean save(MultipartFile file, Long userId) {
    if (null == file || null == userId) {
      return false;
    }
    OssFileResult result;
    if ("signature.png".equalsIgnoreCase(file.getOriginalFilename())) {
      // 手写电子签名
      result = ossClient.uploadCompressPic(file, 0.25D, 100L, 1.0D);
    } else {
      // 导入图片
      result = ossClient.uploadCompressPic(file);
    }
    if (null == result) {
      return false;
    }
    SysFileSignature sysFileSignature = new SysFileSignature();
    SysUser sysUser = sysUserService.getById(userId);
    sysFileSignature.setUserId(sysUser.getId());
    sysFileSignature.setRealname(sysUser.getRealname());
    sysFileSignature.setType(result.getType());
    sysFileSignature.setVersionId(result.getVersionId());
    sysFileSignature.setName(result.getName());
    sysFileSignature.setBucketName(result.getBucketName());
    sysFileSignature.setObjectKey(result.getObjectKey());
    SysFileSignature sfs = super.getOne(Wrappers.<SysFileSignature>query().eq("user_id", userId).last("LIMIT 1"));
    if (null == sfs) {
      return super.save(sysFileSignature);
    }
    // 删除上传的电子签名
    ossClient.deleteObject(sfs.getObjectKey());
    // 更新电子签名
    sysFileSignature.setId(sfs.getId());
    return super.updateById(sysFileSignature);
  }

  @Override
  public boolean removeById(Serializable id) {
    SysFileSignature sfs = super.getById(id);
    if (null == sfs) {
      return false;
    }
    ossClient.deleteObject(sfs.getObjectKey());
    return super.removeById(id);
  }

  @Override
  public void download(Long userId, HttpServletResponse response) {
    SysFileSignature sfs = getSysFileSignature(userId);
    if (null == sfs) {
      PtAssert.fail("抱歉！该签名文件不存在");
    }
    ossClient.download(sfs.getObjectKey(), response);
  }

  @Override
  public String downloadBase64(Long userId) {
    SysFileSignature sfs = getSysFileSignature(userId);
    if (null == sfs) {
      PtAssert.fail("抱歉！该签名文件不存在");
    }
    StringBuilder base64Image = new StringBuilder();
    base64Image.append("data:image/").append(sfs.getType()).append(";base64,");
    base64Image.append(ImageUtils.convertBase64(ossClient.download(sfs.getObjectKey())));
    return base64Image.toString();
  }

  private SysFileSignature getSysFileSignature(Long userId) {
    return super.getOne(Wrappers.<SysFileSignature>query().eq("user_id", userId).last("LIMIT 1"));
  }

  @Override
  public SysFileSignature getByUserId(Long userId) {
    return super.getOne(Wrappers.<SysFileSignature>query().eq("user_id", userId).last("LIMIT 1"));
  }

  @Override
  public List<SysFileSignature> getByUserIds(List<Long> userIds) {
    return super.list(Wrappers.<SysFileSignature>query().in("user_id", userIds));
  }
}
