package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.Tree;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysFileTemplateClassify;
import com.patzn.lims.sys.mapper.SysFileTemplateClassifyMapper;
import com.patzn.lims.sys.service.ISysFileTemplateClassifyService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 模板文件分类表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-14
 */
@Service
public class SysFileTemplateClassifyServiceImpl extends BaseServiceImpl<SysFileTemplateClassifyMapper, SysFileTemplateClassify> implements ISysFileTemplateClassifyService {


    @Override
    public Page<SysFileTemplateClassify> page(Page<SysFileTemplateClassify> page, SysFileTemplateClassify sysFileTemplateClassify) {
        if (null != sysFileTemplateClassify.getId()) {
            // 递归分页
            return page.setRecords(baseMapper.selectPageRecursive(page, sysFileTemplateClassify));
        }
        Wrapper wrapper = new QueryWrapper<>(sysFileTemplateClassify);
        return page(page, wrapper);
    }


    @Override
    public List<SysFileTemplateClassify> list(SysFileTemplateClassify sysFileTemplateClassify) {
        return list(new QueryWrapper<>(sysFileTemplateClassify));
    }

    @Override
    public List<Tree> getTree(SysFileTemplateClassify sysFileTemplateClassify) {
        return baseMapper.selectTree(sysFileTemplateClassify, false);
    }
}
