package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.core.oss.OssFileResult;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.dto.SysFileTemplateDTO;
import com.patzn.lims.sys.entity.SysFileTemplate;
import com.patzn.lims.sys.mapper.SysFileTemplateMapper;
import com.patzn.lims.sys.service.ISysFileTemplateService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;

/**
 * <p>
 * 模板文件表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-04-02
 */
@Service
public class SysFileTemplateServiceImpl extends BaseServiceImpl<SysFileTemplateMapper, SysFileTemplate> implements ISysFileTemplateService {

    @Autowired
    private OssClient ossClient;

    @Override
    public Page<SysFileTemplate> page(Page<SysFileTemplate> page, SysFileTemplateDTO dto) {
        if (null != dto.getClassifyId()) {
            // 递归分页
            return page.setRecords(baseMapper.selectPageRecursive(page, dto));
        }
        return page.setRecords(baseMapper.selectPageByDto(page, dto));
    }


    @Override
    public boolean save(MultipartFile file, SysFileTemplate sysFileTemplate) {
        if (null == sysFileTemplate) {
            return false;
        }
        OssFileResult result = ossClient.upload(file);
        if (null == result) {
            return false;
        }
        sysFileTemplate.setType(result.getType());
        sysFileTemplate.setVersionId(result.getVersionId());
        sysFileTemplate.setName(result.getName());
        sysFileTemplate.setBucketName(result.getBucketName());
        sysFileTemplate.setObjectKey(result.getObjectKey());
        return super.save(sysFileTemplate);
    }


    @Override
    public boolean removeById(Serializable id) {
        SysFileTemplate sysFileTemplate = super.getById(id);
        if (null == sysFileTemplate) {
            return false;
        }
        ossClient.deleteObject(sysFileTemplate.getObjectKey());
        return super.removeById(id);
    }


    @Override
    public void download(Long id, HttpServletResponse response) {
        SysFileTemplate sysFileTemplate = super.getById(id);
        if (null == sysFileTemplate) {
            PtAssert.fail("抱歉！该模板文件不存在");
        }
        String filename = sysFileTemplate.getName() + "." + sysFileTemplate.getType();
        ossClient.download(sysFileTemplate.getObjectKey(), filename, response);
    }

    @Override
    public boolean removeByIds(Long[] ids) {
        return super.remove(Wrappers.<SysFileTemplate>query().in("id", ids));
    }

    @Override
    public SysFileTemplate getByAlias(Long companyId, String alias, String service) {
        QueryWrapper<SysFileTemplate> wrapper = Wrappers.<SysFileTemplate>query().eq("company_id", companyId)
                .eq("alias", alias);
        if (StringUtils.isNotEmpty(service)) {
            wrapper.eq("service", service);
        }
        wrapper.last("LIMIT 1");
        return super.getOne(wrapper);
    }
}
