package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.sys.entity.SysFolder;
import com.patzn.lims.sys.enums.FolderAuthorizeEnum;
import com.patzn.lims.sys.mapper.SysFolderMapper;
import com.patzn.lims.sys.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 文件夹表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-10-30
 */
@Service
public class SysFolderServiceImpl extends BaseServiceImpl<SysFolderMapper, SysFolder> implements ISysFolderService {

    @Autowired
    private ISysFileService sysFileService;
    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private ISysUserRelRoleService sysUserRelRoleService;
    @Autowired
    private ISysRoleRelFileFolderService sysRoleRelFileFolderService;


    @Override
    public Page<SysFolder> page(Page<SysFolder> page, SysFolder sysFolder) {
        QueryWrapper wrapper = new QueryWrapper<>(sysFolder);
        wrapper.select("id,pid,name").orderByDesc("sort");
        return page(page, wrapper);
    }


    @Override
    public List<SysFolder> list(SysFolder sysFolder) {
        return list(new QueryWrapper<>(sysFolder).select("id,pid,name").orderByDesc("sort"));
    }


    @Override
    public List<SysFolder> listUserAuthorize(Account account, SysFolder sysFolder) {
        return baseMapper.selectListUserAuthorize(account, sysFolder);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean removeById(Account account, Long id) {
        SysFolder sysFolder = baseMapper.selectById(id);
        PtAssert.fail(null == sysFolder, "该文件夹不存在，无法删除");
        PtAssert.fail(null == sysFolder.getPid() || 0 == sysFolder.getPid().longValue(),
                "根文件夹无删除权限");

        // 判断是否存在子文件夹
        int count = baseMapper.selectCount(Wrappers.<SysFolder>query().eq("pid", id));
        if (count <= 0) {
            // 判断文件夹中是否存在文件
            count = sysFileService.countByFolderId(id);
        }
        if (count >= 1) {
            PtAssert.fail("文件夹中存在文件无法直接删除");
        }
        if (!sysRoleRelFileFolderService.getUserAuthorize(account, id, FolderAuthorizeEnum.REMOVE)) {
            PtAssert.fail("抱歉！您无该文件夹删除权限");
        }
        return removeById(id) && sysRoleRelFileFolderService.removeByFolderId(id);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean save(SysFolder sysFolder) {
        if (super.save(sysFolder)) {
            Account account = LoginHelper.getAccount();
            // 获取第一个关联角色
            Long roleId;
            if (account.getAdmin() == 1) {
                roleId = sysRoleService.getFirstRelRole(sysFolder.getCompanyId());
            } else {
                roleId = sysUserRelRoleService.getFirstRelRoleId(account.getCompanyId(), account.getUserId());
            }
            // 授予角色查看上传删除权限
            if (null != roleId) {
                sysRoleRelFileFolderService.saveLookUploadRemoveAuthorize(sysFolder.getCompanyId(),
                        roleId, sysFolder.getId());
            }
            return true;
        }
        return false;
    }


    @Override
    public boolean initRoot(Long companyId, String companyName) {
        SysFolder sysFolder = new SysFolder();
        sysFolder.setCompanyId(companyId);
        sysFolder.setName(companyName);
        sysFolder.setPid(0L);
        return super.save(sysFolder);
    }


    @Override
    public List<Integer> getAuthorize(Account account, Long id) {
        return sysRoleRelFileFolderService.getAuthorizeByFolderId(account, id);
    }
}
