package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.sys.entity.SysForm;
import com.patzn.lims.sys.mapper.SysFormMapper;
import com.patzn.lims.sys.service.ISysFormService;
import com.patzn.lims.sys.vo.SysFormVO;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 系统表单表 服务实现类
 * </p>
 *
 * @author hubin
 * @since 2019-01-09
 */
@Service
public class SysFormServiceImpl extends BaseServiceImpl<SysFormMapper, SysForm> implements ISysFormService {

    @Override
    public IPage<SysForm> page(Page<SysForm> page, SysForm sysForm) {
        return page(page, Wrappers.query(sysForm));
    }

    @Override
    public Page<SysFormVO> pageVO(Page<SysFormVO> page, SysFormVO vo) {
        return page.setRecords(baseMapper.pageByVO(page, vo));
    }

    @Override
    public List<SysForm> listByButtonCode(String buttonCode) {
        return baseMapper.selectByButtonCode(buttonCode);
    }

    @Override
    public boolean save(SysForm sysForm) {
        Account account = LoginHelper.getAccount();
        sysForm.setOperator(account.getUserName());
        sysForm.setUid(account.getUserId());
        sysForm.setCtime(new Date());
        return super.save(sysForm);
    }

    @Override
    public boolean updateById(SysForm sysForm) {
        Account account = LoginHelper.getAccount();
        sysForm.setLid(account.getUserId());
        sysForm.setOperator(account.getUserName());
        sysForm.setLtime(new Date());
        return super.updateById(sysForm);
    }
}
