package com.patzn.lims.sys.service.impl;

import com.baomidou.kisso.common.encrypt.RSA;
import com.baomidou.kisso.common.util.RandomUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.sys.entity.SysIsv;
import com.patzn.lims.sys.mapper.SysIsvMapper;
import com.patzn.lims.sys.service.ISysIsvService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.security.Key;
import java.util.Map;

/**
 * <p>
 * ISV 信息表 服务实现类
 * </p>
 *
 * @author hubin
 * @since 2019-04-04
 */
@Slf4j
@Service
public class SysIsvServiceImpl extends ServiceImpl<SysIsvMapper, SysIsv> implements ISysIsvService {

    /**
     * 重写 save 方法生成 isv 信息
     */
    @Override
    public boolean save(SysIsv sysIsv) {
        try {
            sysIsv.setAppKey(IdWorker.getIdStr());
            sysIsv.setSecret(RandomUtil.getCharacterAndNumber(18));
            Map<String, Key> keyMap = RSA.genKeyPair();
            sysIsv.setPublicKey(RSA.getPublicKey(keyMap));
            sysIsv.setPrivateKey(RSA.getPrivateKey(keyMap));
        } catch (Exception e) {
            log.error("ISV 密钥生成失败", e);
            PtAssert.fail("密钥生成失败，请联系管理员");
        }
        return super.save(sysIsv);
    }
}
