//package com.patzn.lims.sys.service.impl;
//
//import com.patzn.lims.core.web.LoginHelper;
//import com.patzn.cloud.commons.toolkit.JacksonUtils;
//import com.patzn.lims.core.web.Account;
//import com.patzn.lims.sys.dto.MqMsgDTO;
//import com.patzn.lims.sys.dto.WsMsgDTO;
//import com.patzn.lims.sys.entity.SysMessage;
//import com.patzn.lims.sys.mapper.SysMessageMapper;
//import com.patzn.lims.sys.service.ISysMessageService;
//import com.patzn.lims.core.web.BaseServiceImpl;
//import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
//import com.baomidou.mybatisplus.core.toolkit.Wrappers;
//import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
//import com.patzn.lims.sys.service.ISysUserRelMessageService;
//import com.patzn.lims.sys.vo.SysMessageListVO;
//import com.patzn.lims.sys.vo.SysMessageVO;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.collections.CollectionUtils;
//import org.apache.commons.lang3.StringUtils;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.messaging.simp.SimpMessagingTemplate;
//import org.springframework.stereotype.Service;
//
//import java.util.HashMap;
//import java.util.List;
//import java.util.Map;
//
///**
// * <p>
// * 系统消息表 服务实现类
// * </p>
// *
// * @author wwd
// * @since 2020-03-18
// */
//@Slf4j
//@Service
//public class SysMessageServiceImpl extends BaseServiceImpl<SysMessageMapper, SysMessage> implements ISysMessageService {
//
//
//    @Autowired
//    private ISysUserRelMessageService sysUserRelMessageService;
//    @Autowired
//    private SimpMessagingTemplate messagingTemplate;
//
//    @Override
//    public Page<SysMessage> page(Page<SysMessage> page, SysMessage sysMessage) {
//        QueryWrapper<SysMessage> wrapper = Wrappers.<SysMessage>query(sysMessage);
//        return this.page(page, wrapper);
//    }
//
//    @Override
//    public Map getMyMessage(Long userId) {
//        Map map = new HashMap(4);
//        int sum = 0;
//        List<Map<String, Object>> typeCountMapList = sysUserRelMessageService.selectTypeCountMapList(userId);
//        if (CollectionUtils.isNotEmpty(typeCountMapList)) {
//            int informSum = 0;
//            int noticeSum = 0;
//            int todoSum = 0;
//            for (Map<String, Object> typeCountMap : typeCountMapList) {
//                Object numObj = typeCountMap.get("num");
//                Object typeObj = typeCountMap.get("type");
//                if (null == numObj || null == typeObj) {
//                    continue;
//                }
//                int num = Integer.valueOf(String.valueOf(numObj));
//                String type = String.valueOf(typeObj);
//                if ("0".equals(type)) {
//                    informSum = num;
//                } else if ("1".equals(type)) {
//                    noticeSum = num;
//                } else if ("2".equals(type)) {
//                    todoSum = num;
//                }
//            }
//            // 总消息数
//            sum = informSum + noticeSum + todoSum;
//            // 通知
//            if (informSum > 0) {
//                map.put("informList", new SysMessageListVO(informSum,
//                        sysUserRelMessageService.selectMyMessage(userId, 0)));
//            }
//            // 消息
//            if (noticeSum > 0) {
//                map.put("noticeList", new SysMessageListVO(noticeSum,
//                        sysUserRelMessageService.selectMyMessage(userId, 1)));
//            }
//            // 待办
//            if (todoSum > 0) {
//                map.put("todoList", new SysMessageListVO(todoSum,
//                        sysUserRelMessageService.selectMyMessage(userId, 2)));
//            }
//        }
//        // 总消息数
//        map.put("sum", sum);
//        return map;
//    }
//
//
//    @Override
//    public void sendMsg(String uri, String content, String title, Account account, List<Long> toUserId) {
//        try {
//            MqMsgDTO mqMsg = new MqMsgDTO();
//            mqMsg.setUid(account.getUserId());
//            mqMsg.setCompanyId(account.getCompanyId());
//            mqMsg.setSender(account.getUserName());
//            mqMsg.setTitle(title.toString());
//            mqMsg.setContent(content.toString());
//            mqMsg.setType(1);
//            mqMsg.setUri(uri);
//            mqMsg.setReceiverIds(toUserId);
//            saveMsg(mqMsg);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }
//
//    @Override
//    public Page<SysMessageVO> pageVO(Page page, Long currentUserId, SysMessageVO vo) {
//        vo.setUid(currentUserId);
//        vo.setCompanyId(LoginHelper.getAccount().getCompanyId());
//        return page.setRecords(baseMapper.pageVO(page, vo));
//    }
//
//
//    @Override
//    public boolean saveMsg(MqMsgDTO dto) {
//        if (CollectionUtils.isNotEmpty(dto.getReceiverIds())) {
//            send(dto);
//        } else {
//            String uri = dto.getUri();
//            if (null != uri && null != dto.getCompanyId()) {
//                List<Long> personList = sysUserRelMessageService.listPersonsByLabelUri(dto.getCompanyId(), uri);
//                if (CollectionUtils.isNotEmpty(personList)) {
//                    dto.setReceiverIds(personList);
//                    send(dto);
//                }
//            }
//        }
//        return true;
//    }
//
//    private boolean send(MqMsgDTO mqMsg) {
//        if (null == mqMsg || CollectionUtils.isEmpty(mqMsg.getReceiverIds())
//                || StringUtils.isEmpty(mqMsg.getTitle()) || StringUtils.isEmpty(mqMsg.getContent())) {
//            return false;
//        }
//        SysMessage sysMessage = mqMsg.convert(SysMessage.class);
//        try {
//            if (super.save(sysMessage) && sysUserRelMessageService.save(sysMessage, mqMsg.getReceiverIds())) {
//                // 推送 MQ 系统通知
//                for (Long userId : mqMsg.getReceiverIds()) {
//                    if (null == userId) {
//                        continue;
//                    }
//                    sendToUser(userId, new WsMsgDTO(sysMessage.getId(), 0, mqMsg.getTitle(), mqMsg.getSender()));
//                }
////                // 推送 WeChat
////                sendToWeChat(mqMsg);
//                return true;
//            }
//        } catch (Throwable t) {
//            log.error("send error: {} , message: {}", null == sysMessage ?
//                    JacksonUtils.toJSONString(mqMsg) :
//                    JacksonUtils.toJSONString(sysMessage), t);
//        }
//        return false;
//    }
//
//    private boolean sendToUser(Long userId, WsMsgDTO wsMsgDTO) {
//        if (null == userId) {
//            return false;
//        }
//        String user = String.valueOf(userId);
//        try {
//            // 发送消息给指定用户
//            messagingTemplate.convertAndSendToUser(user, wsMsgDTO.TOPIC_MESSAGE, wsMsgDTO);
//        } catch (Throwable throwable) {
//            log.error(String.format("sendToUser(%s) 精准消息发送失败", user), throwable);
//            return false;
//        }
//        return true;
//    }
//}
