package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysModule;
import com.patzn.lims.sys.entity.SysSystem;
import com.patzn.lims.sys.entity.SysUserRelModule;
import com.patzn.lims.sys.enums.SysModuleTypeEnum;
import com.patzn.lims.sys.mapper.SysModuleMapper;
import com.patzn.lims.sys.service.ISysModuleService;
import com.patzn.lims.sys.service.ISysSystemService;
import com.patzn.lims.sys.service.ISysUserRelModuleService;
import com.patzn.lims.sys.vo.SysModuleVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 模块表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-10-25
 */
@Service
public class SysModuleServiceImpl extends BaseServiceImpl<SysModuleMapper, SysModule> implements ISysModuleService {
    @Autowired
    private ISysSystemService systemService;
    @Autowired
    private ISysUserRelModuleService sysUserRelModuleService;


    @Override
    public IPage<SysModule> page(Page<SysModule> page, SysModule sysModule) {
        return page(page, Wrappers.query(sysModule));
    }


    @Override
    public List<SysModule> list(SysModule sysModule) {
        return list(Wrappers.query(sysModule));
    }


    @Override
    public List<SysModule> listCompanyModule(Long companyId, Long systemId) {
        return baseMapper.selectCompanyModule(companyId, systemId);
    }

    @Override
    public List<SysModule> listSystemModule(Long systemId, Account account) {
        return baseMapper.selectSystemModule(systemId, account);
    }

    @Override
    public List<SysModule> listUserModule(Long userId, String type) {
        if (null == userId || StringUtils.isEmpty(type)) {
            return null;
        }
        SysModuleTypeEnum typeEnum = SysModuleTypeEnum.fromName(type.toUpperCase());
        if (null == typeEnum) {
            return null;
        }
        return baseMapper.selectUserModule(userId, typeEnum);
    }


    @Override
    public IPage<SysModuleVO> pageByUserId(Page<SysModuleVO> page, SysModule sysModule, Account account) {
        return page.setRecords(baseMapper.selectByUserId(page, sysModule, account.getUserId()));
    }


    @Override
    public boolean saveRelUser(Long userId, Long moduleId) {
        SysUserRelModule rel = new SysUserRelModule();
        rel.setModuleId(moduleId);
        rel.setUserId(userId);
        return sysUserRelModuleService.save(rel);
    }


    @Override
    public boolean deleteRelUser(Long relId) {
        return sysUserRelModuleService.removeById(relId);
    }


    @Override
    public boolean updateById(SysModule sysModule) {
        if (null == sysModule.getSystemId()) {
            return false;
        }
        verifyModuleName(sysModule);
        return super.updateById(sysModule);
    }

    @Override
    public boolean save(SysModule sysModule) {
        if (null == sysModule.getSystemId()) {
            return false;
        }
        verifyModuleName(sysModule);
        return super.save(sysModule);
    }

    /**
     * 模块名称校验
     */
    private void verifyModuleName(SysModule sysModule) {
        SysSystem system = systemService.getById(sysModule.getSystemId());
        PtAssert.fail(null == system, "选择系统模块不存在，请联系管理员");

        SysModuleTypeEnum typeEnum = SysModuleTypeEnum.fromName(system.getTheme());
        PtAssert.fail(null == typeEnum, "选择系统模块不存在关联模块类型，请联系管理员");

        sysModule.setType(typeEnum);

        if (super.count(Wrappers.<SysModule>query()
                .eq("name", sysModule.getName())
                .ne(null != sysModule.getId(), "id", sysModule.getId())) > 0) {
            PtAssert.fail("抱歉!该模块名称已存在，请改换其它名称。");
        }
    }
}
