package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysProvince;
import com.patzn.lims.sys.mapper.SysProvinceMapper;
import com.patzn.lims.sys.service.ISysCityService;
import com.patzn.lims.sys.service.ISysProvinceService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 省份表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-07-10
 */
@Service
public class SysProvinceServiceImpl extends BaseServiceImpl<SysProvinceMapper, SysProvince> implements ISysProvinceService {
  @Autowired
  private ISysCityService sysCityService;

  @Override
  public Page<SysProvince> page(Page<SysProvince> page, SysProvince sysProvince) {
    QueryWrapper<SysProvince> wrapper = Wrappers.<SysProvince>query(sysProvince);
    if (StringUtils.isNotEmpty(sysProvince.getCode())) {
      wrapper.like("code", sysProvince.getCode());
      sysProvince.setCode(null);
    }
    if (StringUtils.isNotEmpty(sysProvince.getCn())) {
      wrapper.like("cn", sysProvince.getCn());
      sysProvince.setCn(null);
    }
    if (StringUtils.isNotEmpty(sysProvince.getCountryCode2())) {
      wrapper.like("country_code2", sysProvince.getCountryCode2());
      sysProvince.setCountryCode2(null);
    }
    return page(page, wrapper);
  }


  @Override
  public List<SysProvince> list(SysProvince sysProvince) {
    QueryWrapper<SysProvince> wrapper = Wrappers.<SysProvince>query(sysProvince);
    if (StringUtils.isNotEmpty(sysProvince.getCn())) {
      wrapper.like("cn", sysProvince.getCn());
      sysProvince.setCn(null);
    }
    wrapper.orderBy(true, false, "id");
    return list(wrapper);
  }

  @Override
  public List<SysProvince> listByCountryCode2(String countryCode2) {
    return super.list(Wrappers.<SysProvince>query().eq("country_code2",
            countryCode2).orderBy(true, false, "code"));
  }

  @Override
  public SysProvince getById(Serializable id) {
    SysProvince sysProvince = super.getById(id);
    if (null == sysProvince) {
      PtAssert.fail("选择省份不存在，请刷新后再试。");
    }
    return sysProvince;
  }

  @Override
  public List<Map<String, Object>> listAll() {
    List<SysProvince> sysProvinceList = list(Wrappers.<SysProvince>query());
    List<Map<String, Object>> listMap = new ArrayList<>();
    for (SysProvince sysProvince : sysProvinceList) {
      Map<String, Object> map = new HashMap<>(4);
      map.put("value", sysProvince.getId());
      map.put("code", sysProvince.getCode());
      map.put("label", sysProvince.getCn());
      map.put("loading", false);
      map.put("children", new ArrayList<>());
      listMap.add(map);
    }
    return listMap;
  }


  @Override
  public boolean save(SysProvince sysProvince) {
    verifyNameCode(sysProvince);
    return super.save(sysProvince);
  }


  @Override
  public boolean updateById(SysProvince sysProvince) {
    verifyNameCode(sysProvince);
    return super.updateById(sysProvince);
  }

  @Override
  public boolean removeById(Serializable id) {
    SysProvince sysProvince = getById(id);
    PtAssert.fail(null == sysProvince, "该省份不存在");
    PtAssert.fail(sysCityService.existByProvinceCode(sysProvince.getCode()),
      "该省份存在下级城市信息，必须先删除城市信息");
    return super.removeById(id);
  }

  /**
   * 校验名称编号
   */
  private void verifyNameCode(SysProvince sysProvince) {
    if (baseMapper.selectCountOrNameCode(sysProvince) > 0) {
      PtAssert.fail("抱歉!省份名称或编号已存在，请重新输入。");
    }
  }

  @Override
  public boolean existByCountryCode2(String countryCode2) {
    return super.count(Wrappers.<SysProvince>query().eq("country_code2",
      countryCode2)) > 0;
  }
}
