package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysRoleRelFileFolder;
import com.patzn.lims.sys.enums.FolderAuthorizeEnum;
import com.patzn.lims.sys.mapper.SysRoleRelFileFolderMapper;
import com.patzn.lims.sys.service.ISysRoleRelFileFolderService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 角色文件夹关联表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-11-06
 */
@Service
public class SysRoleRelFileFolderServiceImpl extends BaseServiceImpl<SysRoleRelFileFolderMapper, SysRoleRelFileFolder> implements ISysRoleRelFileFolderService {


    @Override
    public Page<SysRoleRelFileFolder> page(Page<SysRoleRelFileFolder> page, SysRoleRelFileFolder sysRoleRelFileFolder) {
        Wrapper wrapper = new QueryWrapper<>(sysRoleRelFileFolder);

        return this.page(page, wrapper);
    }


    @Override
    public List<SysRoleRelFileFolder> list(SysRoleRelFileFolder sysRoleRelFileFolder) {
        return this.list(new QueryWrapper<>(sysRoleRelFileFolder));
    }


    @Override
    public List<SysRoleRelFileFolder> getRelFileFolder(Long roleId, String authorize) {
        FolderAuthorizeEnum folderAuthorizeEnum = FolderAuthorizeEnum.valueOf(authorize);
        return this.list(Wrappers.<SysRoleRelFileFolder>query().select("folder_id AS folderId").eq("role_id", roleId).eq("authorize", folderAuthorizeEnum.getValue()));
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveRoleAuthorize(Long companyId, Long roleId, Long[] folderIds, FolderAuthorizeEnum folderAuthorizeEnum) {
        if (null == roleId) {
            return false;
        }
        // 删除历史关联，批量新增新的关联
        baseMapper.delete(Wrappers.<SysRoleRelFileFolder>query().eq("role_id", roleId).eq("authorize", folderAuthorizeEnum.getValue()));
        if (null != folderIds && folderIds.length >= 1) {
            List<SysRoleRelFileFolder> relList = new ArrayList<>();
            for (Long folderId : folderIds) {
                SysRoleRelFileFolder rel = new SysRoleRelFileFolder();
                rel.setCompanyId(companyId);
                rel.setAuthorize(folderAuthorizeEnum);
                rel.setFolderId(folderId);
                rel.setRoleId(roleId);
                relList.add(rel);
            }
            return super.saveBatch(relList);
        }
        return true;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveLookUploadRemoveAuthorize(Long companyId, Long roleId, Long folderId) {
        List<SysRoleRelFileFolder> relList = new ArrayList<>();
        // 查看
        SysRoleRelFileFolder look = new SysRoleRelFileFolder();
        look.setCompanyId(companyId);
        look.setFolderId(folderId);
        look.setRoleId(roleId);
        look.setAuthorize(FolderAuthorizeEnum.LOOK);
        relList.add(look);
        // 上传
        SysRoleRelFileFolder upload = new SysRoleRelFileFolder();
        upload.setCompanyId(companyId);
        upload.setFolderId(folderId);
        upload.setRoleId(roleId);
        upload.setAuthorize(FolderAuthorizeEnum.UPLOAD);
        relList.add(upload);
        // 删除
        SysRoleRelFileFolder remove = new SysRoleRelFileFolder();
        remove.setCompanyId(companyId);
        remove.setFolderId(folderId);
        remove.setRoleId(roleId);
        remove.setAuthorize(FolderAuthorizeEnum.REMOVE);
        relList.add(remove);
        return super.saveBatch(relList);
    }


    @Override
    public boolean getUserAuthorize(Account account, Long folderId, FolderAuthorizeEnum authorize) {
        return baseMapper.selectUserAuthorize(account, folderId, authorize.getValue()) >= 1;
    }


    @Override
    public boolean removeByFolderId(Long folderId) {
        return super.remove(Wrappers.<SysRoleRelFileFolder>query().eq("folder_id", folderId));
    }

    @Override
    public List<Integer> getAuthorizeByFolderId(Account account, Long folderId) {
        List<Integer> authorizeList = baseMapper.selectAuthorizeByFolderId(account.getCompanyId(), account.getUserId(), folderId);
        if (CollectionUtils.isEmpty(authorizeList)) {
            authorizeList = baseMapper.selectAuthorizeRecursiveByFolderId(account.getCompanyId(), account.getUserId(), folderId);
        }
        return authorizeList;
    }
}
