package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.sys.entity.SysRole;
import com.patzn.lims.sys.mapper.SysRoleMapper;
import com.patzn.lims.sys.service.ISysRoleService;
import com.patzn.lims.sys.vo.SysRoleVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-08-02
 */
@Service
public class SysRoleServiceImpl extends BaseServiceImpl<SysRoleMapper, SysRole> implements ISysRoleService {


    @Override
    public Page<SysRoleVO> page(Page<SysRoleVO> page, SysRole sysRole) {
        if (null != sysRole.getId()) {
            // 递归分页情况
            return pageRecursive(page, sysRole);
        }
        return page.setRecords(baseMapper.selectPageVo(page, sysRole));
    }


    @Override
    public Page<SysRoleVO> pageRecursive(Page<SysRoleVO> page, SysRole sysRole) {
        return page.setRecords(baseMapper.selectPageRecursive(page, sysRole));
    }


    @Override
    public List<SysRole> list(SysRole sysRole) {
        return list(Wrappers.query(sysRole.setStatus(1)));
    }


    @Override
    public List<SysRole> listByRoleNames(Collection<String> roleNames, Long companyId) {
        return super.list(Wrappers.<SysRole>query().select("id", "pid", "name")
                .eq("company_id", companyId)
                .in("name", roleNames));
    }


    @Override
    public boolean save(SysRole sysRole) {
        verifyRoleName(sysRole);
        return super.save(sysRole);
    }


    @Override
    public boolean updateById(SysRole sysRole) {
        verifyRoleName(sysRole);
        return super.updateById(sysRole);
    }


    /**
     * 角色名称校验
     */
    private void verifyRoleName(SysRole sysRole) {
        if (super.count(Wrappers.<SysRole>query()
                .eq("company_id", sysRole.getCompanyId())
                .eq("name", sysRole.getName())
                .ne(null != sysRole.getId(), "id", sysRole.getId())) > 0) {
            PtAssert.fail("抱歉!该角色名称已存在，请改换名称。");
        }
    }


    @Override
    public SysRoleVO getVoById(Long companyId, Long id) {
        return baseMapper.selectVoById(companyId, id);
    }


    @Override
    public List<SysRole> getRoleTree(String name) {
        return list(Wrappers.<SysRole>query().select("id", "pid", "name")
                .like(StringUtils.isNotEmpty(name), "name", name)
                .eq("company_id", LoginHelper.getAccount().getCompanyId())
                .eq("status", 1).orderByAsc("sort"));
    }


    @Override
    public List<SysRole> listByUserId(Long userId) {
        return baseMapper.selectByUserId(userId);
    }


    @Override
    public Long getFirstRelRole(Long companyId) {
        SysRole sysRole = super.getOne(Wrappers.<SysRole>query()
                .select("id").eq("company_id",
                companyId).last("LIMIT 1"));
        return null == sysRole ? null : sysRole.getId();
    }


    @Override
    public String getNamesByUserId(Long userId) {
        return baseMapper.selectNamesByUserId(userId);
    }
}
