package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysSystem;
import com.patzn.lims.sys.mapper.SysSystemMapper;
import com.patzn.lims.sys.service.ISysSystemService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 系统表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-07-10
 */
@Service
public class SysSystemServiceImpl extends BaseServiceImpl<SysSystemMapper, SysSystem> implements ISysSystemService {

    @Override
    public IPage<SysSystem> page(Page<SysSystem> page, SysSystem sysSystem) {
        return this.page(page, Wrappers.query(sysSystem).orderByAsc("sort"));
    }

    @Override
    public List<SysSystem> listIdName() {
        List<SysSystem> systemList = new ArrayList<>();
        SysSystem sysSystem = new SysSystem();
        sysSystem.setId(0L);
        sysSystem.setName("平台首页");
        systemList.add(sysSystem);
        systemList.addAll(this.list(Wrappers.<SysSystem>query()
                .select("id", "name", "theme")
                .eq("status", 1)));
        return systemList;
    }
}
