package com.patzn.lims.sys.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.sys.entity.SysUser;
import com.patzn.lims.sys.entity.SysUserPlatform;
import com.patzn.lims.sys.mapper.SysUserPlatformMapper;
import com.patzn.lims.sys.service.ISysUserPlatformService;
import com.patzn.lims.sys.service.ISysUserService;
import com.patzn.lims.sys.service.ISysWxmpUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 第三方平台用户表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-11-17
 */
@Service
public class SysUserPlatformServiceImpl extends BaseServiceImpl<SysUserPlatformMapper, SysUserPlatform> implements ISysUserPlatformService {

    @Autowired
    private ISysWxmpUserService sysWxmpUserService;
    @Autowired
    private ISysUserService sysUserService;


    @Override
    public IPage<SysUserPlatform> page(Page<SysUserPlatform> page, SysUserPlatform sysUserPlatform) {
        return this.page(page, Wrappers.query(sysUserPlatform));
    }


    @Override
    public List<SysUserPlatform> list(SysUserPlatform sysUserPlatform) {
        return this.list(Wrappers.query(sysUserPlatform));
    }


    @Override
    public boolean bindWechat(Long userId, String code) {
        boolean result = false;
//        WxUser wxUser = WxUser.convert(WechatKit.getWxUser(code));
//        if (null != wxUser && null != wxUser.getOpenid()) {
//            SysUserPlatform sysUserPlatform = wxUser.convert(SysUserPlatform.class);
//            sysUserPlatform.setPlatform(0);
//            sysUserPlatform.setUserId(userId);
//            result = bindUser(sysUserPlatform);
//        }
        return result;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean bindUser(SysUserPlatform sysUserPlatform) {
        if (null != sysUserPlatform.getUserId()) {
            SysUser sysUser = sysUserService.getById(sysUserPlatform.getUserId());
            if (null != sysUser) {
                // 更新绑定关系
                sysWxmpUserService.updateByUnionId(sysUserPlatform.getUserId(), sysUserPlatform.getUnionid());
                SysUserPlatform sup = super.getOne(Wrappers.<SysUserPlatform>query()
                        .eq("user_id", sysUser.getId())
                        .eq("platform", sysUserPlatform.getPlatform()));
                if (null == sup) {
                    // 绑定
                    return super.save(sysUserPlatform);
                }
                // 重新绑定
                sysUserPlatform.setId(sup.getId());
                return super.updateById(sysUserPlatform);
            }
        }
        return false;
    }


    @Override
    public SysUser getBindUser(String openid, int platform) {
        List<SysUserPlatform> supList = super.list(Wrappers.<SysUserPlatform>query()
                .eq("openid", openid).eq("platform", platform));
        if (null == supList || supList.size() > 1) {
            return null;
        }
        return sysUserService.getById(supList.get(0).getUserId());
    }


    @Override
    public SysUserPlatform getWechatInfo(Long userId) {
        return super.getOne(Wrappers.<SysUserPlatform>query()
                .select("nickname", "headimgurl")
                .eq("user_id", userId)
                .eq("platform", 0));
    }
}
